#ifndef BUILDING_H_INCLUDED
#define BUILDING_H_INCLUDED

class Building
{
	public:
		Building(int height = 0, double area = 0, const char* = "");
		Building(const Building&);
		Building& operator=(const Building&);
		~Building();

		int getHeight() const { return this->height; }
		double getArea() const { return this->area; }
		const char* getAddress() const { return (this->address) ? this->address : ""; }

		void setHeight(int);
		void setArea(double);
		void setAddress(const char*);

		void print() const;

	protected:
		virtual void printTitle() const;
		virtual void printOwnDetails() const;

	private:
		int height;
		double area;
		char* address;
};

#endif // BUILDING_H_INCLUDED
