#ifndef HOUSE_H_INCLUDED
#define HOUSE_H_INCLUDED

#include "Building.h"

class House : public Building
{
	public:
		House(int height = 0, double area = 0, const char* address = "", int floors = 0, const char* owner = "");
		House(const House&);
		House& operator=(const House&);
		~House();

		int getFloors() const { return this->countFloors; }
		const char* getOwner() const { return (this->owner) ? this->owner : ""; }

		void setFloors(int);
		void setOwner(const char*);

	protected:
		virtual void printTitle() const;
		virtual void printOwnDetails() const;

	private:
		int countFloors;
		char* owner;
};

#endif //HOUSE_H_INCLUDED
